/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import com.nokia.mid.appl.calc2.Local;
import common.util.Tools;

public final class Calculator {
    private static final Calculator instance = new Calculator();

    private Calculator() {
    }

    public static Calculator getInstance() {
        return instance;
    }

    public double add(double operand1, double operand2) {
        return operand1 + operand2;
    }

    public double substract(double operand1, double operand2) {
        return operand1 - operand2;
    }

    public double multiply(double operand1, double operand2) {
        return operand1 * operand2;
    }

    public double divide(double operand1, double operand2) throws ArithmeticException {
        if (operand2 == 0.0) {
            throw new ArithmeticException(Local.getText(4));
        }
        double result = operand1 / operand2;
        return result;
    }

    public double percentage(double operand) {
        return operand / 100.0;
    }

    public double square(double operand) {
        return operand * operand;
    }

    public double sqrt(double operand) throws ArithmeticException {
        double result = Math.sqrt(operand);
        if (Double.isNaN(result)) {
            throw new ArithmeticException(Local.getText(6));
        }
        return result;
    }

    public double reciprocal(double operand) throws ArithmeticException {
        double result = 1.0 / operand;
        if (Double.isInfinite(result)) {
            throw new ArithmeticException(Local.getText(4));
        }
        return result;
    }

    public double sin(double operand) {
        return Math.sin(operand);
    }

    public double cos(double operand) {
        return Math.cos(operand);
    }

    public double tan(double operand) throws ArithmeticException {
        if (operand % 1.5707963267948966 == 0.0 && operand % Math.PI != 0.0) {
            String error = Local.getText(3, new String[]{"TAN(" + Tools.getInstance().doubleToStringRounded(operand, 15) + ")"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        return Math.tan(operand);
    }

    public double asin(double operand) throws ArithmeticException {
        if (operand < -1.0 || operand > 1.0) {
            String error = Local.getText(3, new String[]{"ASIN(" + Tools.getInstance().doubleToStringRounded(operand, 15) + ")"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        return this.atan(operand / this.sqrt(1.0 - this.square(operand)));
    }

    public double acos(double operand) throws ArithmeticException {
        if (operand < -1.0 || operand > 1.0) {
            String error = Local.getText(3, new String[]{"ACOS(" + Tools.getInstance().doubleToStringRounded(operand, 15) + ")"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        return 1.5707963267948966 - this.asin(operand);
    }

    public double atan(double operand) {
        double result = 0.0;
        double modulus = this.modulus(operand);
        if (modulus < 1.0) {
            for (int i = 0; i < 100; ++i) {
                result += this.pow(-1.0 * this.square(operand), i) / (double)(2 * i + 1);
            }
            result *= operand;
        } else if (modulus == 1.0) {
            double result1 = 0.0;
            for (int i = 0; i < 100; ++i) {
                result1 += this.pow(-1.0 * this.square(operand), i) / (double)(2 * i + 1);
            }
            result1 *= operand;
            double result2 = 0.0;
            double sum = 0.0;
            for (int i = 0; i < 100; ++i) {
                sum += this.pow(-1.0 * this.square(operand), -i) / (double)(2 * i + 1);
            }
            result2 = Math.PI * (double)this.signum(operand) / 2.0 - 1.0 / operand * sum;
            result = (result1 + result2) / 2.0;
        } else {
            double sum = 0.0;
            for (int i = 0; i < 100; ++i) {
                sum += this.pow(-1.0 * this.square(operand), -i) / (double)(2 * i + 1);
            }
            result = Math.PI * (double)this.signum(operand) / 2.0 - 1.0 / operand * sum;
        }
        return result;
    }

    public double factorial(double operand) throws ArithmeticException {
        if (Math.floor(operand) != operand) {
            String error = Local.getText(3, new String[]{Tools.getInstance().doubleToStringRounded(operand, 15) + "!"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        if (operand < 0.0) {
            String error = Local.getText(3, new String[]{Tools.getInstance().doubleToStringRounded(operand, 15) + "!"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        if (operand > 170.0) {
            String error = Local.getText(11, new String[]{String.valueOf(15)});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        if (operand == 0.0) {
            return 1.0;
        }
        double result = operand;
        for (long i = (long)operand - 1L; i > 1L; --i) {
            result *= (double)i;
        }
        return result;
    }

    public double pow(double basis, int exponent) throws ArithmeticException {
        if (exponent == 0) {
            return 1.0;
        }
        if (exponent == 1) {
            return basis;
        }
        if (basis == 0.0) {
            return 0.0;
        }
        if (basis == 1.0) {
            return 1.0;
        }
        if (exponent > 999999) {
            String error = Local.getText(11, new String[]{String.valueOf(15)});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        int iterations = 0;
        iterations = exponent < 0 ? -exponent : exponent;
        --iterations;
        double result = basis;
        for (int i = 0; i < iterations; ++i) {
            result *= basis;
        }
        if (exponent < 0) {
            result = 1.0 / result;
        }
        return result;
    }

    public double pow(double basis, double exponent) throws ArithmeticException {
        if (exponent == 0.0) {
            return 1.0;
        }
        if (exponent == 1.0) {
            return basis;
        }
        if (basis == 0.0) {
            return 0.0;
        }
        if (basis == 1.0) {
            return 1.0;
        }
        if (exponent > 999999.0) {
            String error = Local.getText(11, new String[]{String.valueOf(15)});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        if (basis < 0.0 && Math.floor(exponent) != exponent) {
            String error = null;
            error = exponent < 0.0 ? Local.getText(3, new String[]{"(" + Tools.getInstance().doubleToStringRounded(basis, 15) + ")" + "^" + "(" + Tools.getInstance().doubleToStringRounded(exponent, 15) + ")"}) : Local.getText(3, new String[]{"(" + Tools.getInstance().doubleToStringRounded(basis, 15) + ")" + "^" + Tools.getInstance().doubleToStringRounded(exponent, 15)});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        return this.exp(exponent * this.ln(basis));
    }

    public double log(double operand) throws ArithmeticException {
        if (operand <= 0.0) {
            String error = Local.getText(3, new String[]{"log(" + Tools.getInstance().doubleToStringRounded(operand, 15) + ")"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        return this.ln(operand) / this.ln(10.0);
    }

    public double ln(double operand) throws ArithmeticException {
        if (operand <= 0.0) {
            String error = Local.getText(3, new String[]{"ln(" + Tools.getInstance().doubleToStringRounded(operand, 15) + ")"});
            throw new ArithmeticException(Tools.getInstance().replaceDecimalSeparator(error));
        }
        double result = 0.0;
        double reciprocalSquareRoot = 1.0 / this.sqrt(2.0);
        double squareRoot = this.sqrt(2.0);
        int m = 0;
        if (operand > squareRoot) {
            while (this.pow(2.0, -m) * operand > squareRoot) {
                ++m;
            }
        } else if (operand < reciprocalSquareRoot) {
            while (this.pow(2.0, m) * operand < reciprocalSquareRoot) {
                ++m;
            }
            m = -m;
        }
        result = (double)m * 0.6931471805599453 + this.lnForSmallNumbers(this.pow(2.0, -m) * operand);
        return result;
    }

    private double lnForSmallNumbers(double operand) {
        double result = 0.0;
        double factor = (operand - 1.0) / (operand + 1.0);
        for (int i = 0; i < 10; ++i) {
            result += 1.0 / (double)(2 * i + 1) * this.pow(factor, 2 * i + 1);
        }
        return result *= 2.0;
    }

    private double modulus(double operand) {
        if (operand < 0.0) {
            return -operand;
        }
        return operand;
    }

    private int signum(double operand) {
        if (operand > 0.0) {
            return 1;
        }
        if (operand == 0.0) {
            return 0;
        }
        return -1;
    }

    private double exp(double operand) {
        boolean isNegative;
        if (operand == 0.0) {
            return 1.0;
        }
        if (operand == 1.0) {
            return Math.E;
        }
        double endResult = 1.0;
        boolean bl = isNegative = operand < 0.0;
        if (isNegative) {
            operand = -operand;
        }
        double intermediateResult = operand;
        for (int i = 2; i < 100; ++i) {
            endResult += intermediateResult;
            intermediateResult = intermediateResult * operand / (double)i;
        }
        if (isNegative) {
            return 1.0 / endResult;
        }
        return endResult;
    }
}

